implementation module StdFont

// ********************************************************
//	Concurrent Clean Standard Library Module Version 1.4
//	Copyright 1997 University of Nijmegen
//	
//	Font operations
// ********************************************************

import	StdInt, StdReal, StdChar, StdString, StdArray, StdTuple, StdList
import	StdFontDef
import	osfont, ostoolbox

class FontEnv env where
	openFont			::			 !FontDef	!*env -> (!(!Bool,!Font),!*env)
	openDefaultFont		::						!*env -> (!Font,		 !*env)
	openDialogFont		::						!*env -> (!Font,		 !*env)
	
	getFontNames		::						!*env -> (![FontName],	 !*env)
	getFontStyles		::			 !FontName	!*env -> (![FontStyle],	 !*env)
	getFontSizes		:: !Int !Int !FontName	!*env -> (![FontSize],	 !*env)
	
	getFontCharWidth	:: ! Char	 !Font		!*env -> (!Int,			 !*env)
	getFontCharWidths	:: ![Char]	 !Font		!*env -> (![Int],		 !*env)
	getFontStringWidth	:: ! String	 !Font		!*env -> (!Int,			 !*env)
	getFontStringWidths	:: ![String] !Font		!*env -> (![Int],		 !*env)
	
	getFontMetrics		::			 !Font		!*env -> (!FontMetrics,	 !*env)

instance FontEnv World where
	openFont :: !FontDef !*World -> (!(!Bool,!Font),!*World)
	openFont fDef=:{fName,fStyles,fSize} world
		# (tb,world)		= WorldGetToolbox world
		# (found,font,tb)	= OSselectfont fDef tb
		# world				= WorldSetToolbox tb world
		= ((found,font),world)
	
	openDefaultFont :: !*World -> (!Font,!*World)
	openDefaultFont world
		# (tb,world)		= WorldGetToolbox world
		# (font,tb)			= OSdefaultfont tb
		# world				= WorldSetToolbox tb world
		= (font,world)
	
	openDialogFont :: !*World -> (!Font,!*World)
	openDialogFont world
		# (tb,world)		= WorldGetToolbox world
		# (font,tb)			= OSdialogfont tb
		# world				= WorldSetToolbox tb world
		= (font,world)
	
	getFontNames :: !*World -> (![FontName],!*World)
	getFontNames world
		# (tb,world)		= WorldGetToolbox world
		# (names,tb)		= OSfontnames tb
		# world				= WorldSetToolbox tb world
		= (names,world)
	
	getFontStyles :: !FontName !*World -> (![FontStyle],!*World)
	getFontStyles fName world
		# (tb,world)		= WorldGetToolbox world
		# (styles,tb)		= OSfontstyles fName tb
		# world				= WorldSetToolbox tb world
		= (styles,world)
	
	getFontSizes :: !Int !Int !FontName !*World -> (![FontSize],!*World)
	getFontSizes sizeBound1 sizeBound2 fName world
		# (tb,world)		= WorldGetToolbox world
		# (sizes,tb)		= OSfontsizes sizeBound1 sizeBound2 fName tb
		# world				= WorldSetToolbox tb world
		= (sizes,world)
	
	getFontCharWidth :: !Char !Font !*World -> (!Int,!*World)
	getFontCharWidth char font world
		# (tb,world)		= WorldGetToolbox world
		# (widths,tb)		= OSgetfontcharwidths False 0 [char] font tb
		# world				= WorldSetToolbox tb world
		= (hd widths,world)
	
	getFontCharWidths :: ![Char] !Font !*World -> (![Int],!*World)
	getFontCharWidths chars font world
		# (tb,world)		= WorldGetToolbox world
		# (widths,tb)		= OSgetfontcharwidths False 0 chars font tb
		# world				= WorldSetToolbox tb world
		= (widths,world)
	
	getFontStringWidth :: !String !Font !*World -> (!Int,!*World)
	getFontStringWidth string font world
		# (tb,world)		= WorldGetToolbox world
		# (widths,tb)		= OSgetfontstringwidths False 0 [string] font tb
		# world				= WorldSetToolbox tb world
		= (hd widths,world)
	
	getFontStringWidths :: ![String] !Font !*World -> (![Int],!*World)
	getFontStringWidths strings font world
		# (tb,world)		= WorldGetToolbox world
		# (widths,tb)		= OSgetfontstringwidths False 0 strings font tb
		# world				= WorldSetToolbox tb world
		= (widths,world)
	
	getFontMetrics :: !Font !*World -> (!FontMetrics,!*World)
	getFontMetrics font world
		# (tb,world)		= WorldGetToolbox world
		# ((ascent,descent,leading,maxWidth),tb)
		  					= OSgetfontmetrics False 0 font tb
		# world				= WorldSetToolbox tb world
		= ({fAscent=ascent,fDescent=descent,fLeading=leading,fMaxWidth=maxWidth},world)


//	Get the derived definition of a generated Font.

getFontDef :: !Font -> FontDef
getFontDef font
	= OSfontgetdef font
